//
//  InspectorViewGlyphTextController.h
//  GlyphsCore
//
//  Created by Georg Seifert on 08.02.09.
//  Copyright 2009 schriftgestaltung.de. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <GlyphsCore/GSInspectorViewController.h>

@class GSLayer;
@class GSInspectorView;
@class GSSteppingTextField;

@interface InspectorViewGlyphTextController : GSInspectorViewController {
	NSImage *rightTransferValue;
	NSImage *leftTransferValue;
}

@property (nonatomic, weak) IBOutlet GSSteppingTextField *leftMetricsField;
@property (nonatomic, weak) IBOutlet NSButton *leftMetricsSyncButton;
@property (nonatomic, weak) IBOutlet GSSteppingTextField *widthField;
@property (nonatomic, weak) IBOutlet NSButton *widthMetricsSyncButton;
@property (nonatomic, weak) IBOutlet GSSteppingTextField *rightMetricsField;
@property (nonatomic, weak) IBOutlet NSButton *rightMetricsSyncButton;
@property (nonatomic, weak) IBOutlet NSTextField *leftGroupField;
@property (nonatomic, weak) IBOutlet NSTextField *rightGroupField;

@property (nonatomic, weak) IBOutlet GSSteppingTextField *originField;

@property (nonatomic, weak) IBOutlet NSLayoutConstraint *LSBRightConstraint;
@property (nonatomic, weak) IBOutlet NSLayoutConstraint *RSBLeftConstraint;
@property (nonatomic, weak) IBOutlet NSLayoutConstraint *widthLeftConstraint;
#ifndef GLYPHS_VIEWER

- (void)setAlternateButtons:(NSNotification *)theNotification;

- (IBAction)setLeftMetricsKey:(id)sender;

- (IBAction)setRightMetricsKey:(id)sender;

- (IBAction)setWidthMetricsKey:(id)sender;

- (IBAction)setLeftGroup:(id)sender;

- (IBAction)setRightGroup:(id)sender;

- (void)reloadContent;
#endif
@end
